//this file is part of NeoMule
//Copyright (C)2005 David Xanatos ( Xanatos@Lycos.at / http://NeoMule.tk )
//
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either
//version 2 of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


#pragma once

#include "PrefFunctions.h"

enum EDownloadState;

template<class TYPE_PTR, class TYPE1, class TYPE2>
void MinMax(TYPE_PTR *data, TYPE1 min, TYPE2 max)
{
	if (*data < min)
		*data=min;
	else if (*data > max)
		*data=max;
}

template<class TYPE_PTR, class TYPE>
void Minimal (TYPE_PTR *data, TYPE min)
{
	if (*data < min)
		*data=min;
}

template<class TYPE_PTR, class TYPE>
void Maximal (TYPE_PTR *data, TYPE max)
{
	if (*data > max)
		*data=max;
}

#define UN_INT		(INT_MAX - 1)
#define UN_FLOAT	(-1)

//////////////////////////////////
int Str2Int(CString Buffer, int Min, int Def, int Max);
CString Int2Str(int Nummer);
uint32 Str2UInt(CString Buffer, uint32 Min, uint32 Def, uint32 Max);
CString UInt2Str(uint32 Nummer);
float Str2FloatNum(CString Buffer, float Min, float Def, float Max);
CString FloatNum2Str(float Nummer);

uint32 MinStr2Time (CString Buffer, uint32 Min, uint32 Def, uint32 Max);
CString Time2MinStr(uint32 Time);
uint32 SecStr2Time (CString Buffer, uint32 Min, uint32 Def, uint32 Max);
CString Time2SecStr(uint32 Time);
/////////////////////////////////

CString StrLine(LPCTSTR line, ...);

CString Crypt(CString sNormal);
CString Decrypt(CString sCrypted);

CString DeCodeString(CString String);
CString ParseString(CString &strIn, int &nOffset, TCHAR what);

bool stristrex (const TCHAR *s1, const TCHAR *s2);
bool strcmpex (const TCHAR *s1, const TCHAR *s2);

CString GetDLStateString(EDownloadState nState);

CString CastSecondsToDate(uint32 Secounds);

int wildcmp(TCHAR *wild, TCHAR *string);
ULONG	CastXBytesToI(const CString& strExpr);
CString CastItoUIXBytes(uint64 count);

int CompareSubDirectories(const CString& rstrDir1, const CString& rstrDir2);